<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-4 py-6 sm:px-0">
    <div class="border-4 border-dashed border-gray-200 dark:border-gray-700 rounded-lg p-8">
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white mb-4">Bienvenido al Panel de Administración</h1>
        <p class="text-gray-600 dark:text-gray-400 mb-6">
            Desde aquí puedes gestionar usuarios y configurar el sistema.
        </p>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-6">
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Usuarios</h3>
                <p class="text-3xl font-bold text-indigo-600 dark:text-indigo-400">
                    <?php echo e(\App\Models\User::where('is_admin', false)->count()); ?>

                </p>
                <a href="<?php echo e(route('admin.users.index')); ?>" class="text-indigo-600 dark:text-indigo-400 hover:underline mt-2 inline-block">
                    Ver todos →
                </a>
            </div>
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Usuarios Activos</h3>
                <p class="text-3xl font-bold text-green-600 dark:text-green-400">
                    <?php echo e(\App\Models\User::where('is_admin', false)->where('status', true)->count()); ?>

                </p>
            </div>
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Configuración</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-2">
                    URL del formulario GHL configurada
                </p>
                <a href="<?php echo e(route('admin.settings.index')); ?>" class="text-indigo-600 dark:text-indigo-400 hover:underline mt-2 inline-block">
                    Gestionar →
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Volumes/Extended Disk/Storage/Development/WebServer/jpLogin/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>