<?php $__env->startSection('title', 'Configuración'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-4 py-6 sm:px-0">
    <h1 class="text-3xl font-bold text-gray-900 dark:text-white mb-6">Configuración del Sistema</h1>
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">URL del Formulario GoHighLevel</h2>
        <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">
            Configura la URL del formulario de GoHighLevel al que serán redirigidos los usuarios después del login.
            El sistema agregará automáticamente el parámetro <code class="bg-gray-100 dark:bg-gray-700 px-1 rounded">contact_id</code> con el ID del contacto del usuario.
        </p>
        <form action="<?php echo e(route('admin.settings.update-ghl-url')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="mb-4">
                <label for="ghl_form_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    URL del Formulario *
                </label>
                <input type="url" name="ghl_form_url" id="ghl_form_url" required
                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white"
                    placeholder="https://forms.gohighlevel.com/form/..."
                    value="<?php echo e(old('ghl_form_url', $ghlFormUrl)); ?>">
                <?php $__errorArgs = ['ghl_form_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <?php if($ghlFormUrl): ?>
                    <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">
                        URL actual: <span class="font-mono"><?php echo e($ghlFormUrl); ?></span>
                    </p>
                <?php endif; ?>
            </div>
            <div class="flex justify-end">
                <button type="submit"
                    class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Guardar Configuración
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Volumes/Extended Disk/Storage/Development/WebServer/jpLogin/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>