@extends('layouts.app')

@section('title', 'Login')

@section('content')
<style>
    .login-container {
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, #0066cc 0%, #0052a3 50%, #003d7a 100%);
        padding: 2rem 1rem;
    }
    .login-card {
        background: white;
        border-radius: 1rem;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        width: 100%;
        max-width: 28rem;
        overflow: hidden;
    }
    .login-header {
        background: linear-gradient(135deg, #0066cc 0%, #0052a3 100%);
        padding: 2.5rem 2rem;
        text-align: center;
        color: white;
    }
    .login-icon {
        width: 4rem;
        height: 4rem;
        margin: 0 auto 1rem;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        backdrop-filter: blur(10px);
    }
    .login-form {
        padding: 2rem;
    }
    .form-group {
        margin-bottom: 1.5rem;
    }
    .form-label {
        display: block;
        font-weight: 600;
        color: #374151;
        margin-bottom: 0.5rem;
        font-size: 0.875rem;
    }
    .form-input-wrapper {
        position: relative;
    }
    .form-input-icon {
        position: absolute;
        left: 0.75rem;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
        width: 1.25rem;
        height: 1.25rem;
    }
    .password-toggle {
        position: absolute;
        right: 0.75rem;
        top: 0;
        bottom: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        background: transparent;
        border: none;
        color: #9ca3af;
        cursor: pointer;
        padding: 0;
        margin: 0;
        transition: color 0.2s;
        z-index: 10;
        width: 2rem;
        outline: none;
    }
    .password-toggle:hover {
        color: #0066cc;
    }
    .password-toggle svg {
        width: 1.25rem;
        height: 1.25rem;
        display: block;
    }
    .form-input {
        width: 100%;
        padding: 0.75rem 2.75rem 0.75rem 2.5rem;
        border: 1px solid #d1d5db;
        border-radius: 0.5rem;
        font-size: 1rem;
        transition: all 0.2s;
        background: white;
        box-sizing: border-box;
    }
    .form-input:focus {
        outline: none;
        border-color: #0066cc;
        box-shadow: 0 0 0 3px rgba(0, 102, 204, 0.1);
    }
    .form-checkbox-wrapper {
        display: flex;
        align-items: center;
        margin-bottom: 1.5rem;
    }
    .form-checkbox {
        width: 1rem;
        height: 1rem;
        margin-right: 0.5rem;
        cursor: pointer;
    }
    .form-checkbox-label {
        font-size: 0.875rem;
        color: #374151;
        cursor: pointer;
    }
    .btn-submit {
        width: 100%;
        padding: 0.875rem;
        background: linear-gradient(135deg, #0066cc 0%, #0052a3 100%);
        color: white;
        border: none;
        border-radius: 0.5rem;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s;
        position: relative;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }
    .btn-submit:hover {
        background: linear-gradient(135deg, #0052a3 0%, #003d7a 100%);
        transform: translateY(-1px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }
    .btn-submit:active {
        transform: translateY(0);
    }
    .alert {
        padding: 1rem;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
    }
    .alert-error {
        background: #fef2f2;
        border: 1px solid #fecaca;
        color: #991b1b;
    }
    .alert-success {
        background: #f0fdf4;
        border: 1px solid #bbf7d0;
        color: #166534;
    }
    .alert-icon {
        width: 1.25rem;
        height: 1.25rem;
        margin-right: 0.5rem;
    }
    .footer-text {
        text-align: center;
        margin-top: 1.5rem;
        color: white;
        font-size: 0.875rem;
    }
    .footer-link {
        color: white;
        font-weight: 500;
        text-decoration: underline;
    }
</style>

<div class="login-container">
    <div class="login-card">
        <!-- Header -->
        <div class="login-header">
            <div style="background: white; padding: 1.5rem 2rem; margin: -2.5rem -2rem 1.5rem -2rem; border-radius: 1rem 1rem 0 0;">
                <img src="{{ asset('assets/images/jp-service-cooling-logo.png') }}" alt="JP Service Cooling" style="max-width: 200px; height: auto; margin: 0 auto; display: block;">
            </div>
            <h2 style="font-size: 1.875rem; font-weight: 700; margin-bottom: 0.5rem;">Bienvenido</h2>
            <p style="opacity: 0.9; font-size: 0.875rem;">Ingresa tus credenciales para continuar</p>
        </div>

        <!-- Form -->
        <div class="login-form">
            <form action="{{ route('login') }}" method="POST">
                @csrf
                
                @if (session('error'))
                    <div class="alert alert-error">
                        <svg class="alert-icon" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                        <span>{{ session('error') }}</span>
                    </div>
                @endif
                
                @if (session('success'))
                    <div class="alert alert-success">
                        <svg class="alert-icon" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        <span>{{ session('success') }}</span>
                    </div>
                @endif
                
                @if ($errors->any())
                    <div class="alert alert-error">
                        <svg class="alert-icon" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                        <ul style="list-style: disc; list-style-position: inside; margin: 0;">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Email -->
                <div class="form-group">
                    <label for="email" class="form-label">Correo electrónico</label>
                    <div class="form-input-wrapper">
                        <svg class="form-input-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"></path>
                        </svg>
                        <input id="email" name="email" type="email" autocomplete="email" required
                            class="form-input" placeholder="tu@email.com" value="{{ old('email') }}">
                    </div>
                </div>

                <!-- Password -->
                <div class="form-group">
                    <label for="password" class="form-label">Contraseña</label>
                    <div class="form-input-wrapper">
                        <svg class="form-input-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                        <input id="password" name="password" type="password" autocomplete="current-password" required
                            class="form-input" placeholder="••••••••">
                        <button type="button" class="password-toggle" onclick="togglePassword()" aria-label="Mostrar contraseña">
                            <svg id="eye-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="display: block;">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                            </svg>
                            <svg id="eye-off-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="display: none;">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.29 3.29m0 0L3 12m3.29-5.71L12 12m-5.71 0L12 12m0 0l3.29 3.29M12 12l3.29-3.29m0 0L21 3m-5.71 5.71L12 12m5.71 5.71L21 21"></path>
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Remember Me -->
                <div class="form-checkbox-wrapper">
                    <input id="remember" name="remember" type="checkbox" class="form-checkbox">
                    <label for="remember" class="form-checkbox-label">Recordarme</label>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="btn-submit">
                    Iniciar sesión
                </button>
            </form>
            
            <!-- Footer dentro del card -->
            <p class="footer-text" style="margin-top: 1.5rem; margin-bottom: 0; color: #6b7280; font-size: 0.875rem;">
                ¿Necesitas ayuda? 
                <a href="#" style="color: #0066cc; font-weight: 500; text-decoration: underline;">Contacta al administrador</a>
            </p>
        </div>
    </div>
</div>

<script>
function togglePassword() {
    const passwordInput = document.getElementById('password');
    const eyeIcon = document.getElementById('eye-icon');
    const eyeOffIcon = document.getElementById('eye-off-icon');
    
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        eyeIcon.style.display = 'none';
        eyeOffIcon.style.display = 'block';
    } else {
        passwordInput.type = 'password';
        eyeIcon.style.display = 'block';
        eyeOffIcon.style.display = 'none';
    }
}
</script>
@endsection

