@extends('layouts.admin')

@section('title', 'Ver Usuario')

@section('content')
<div class="px-4 py-6 sm:px-0">
    <div class="mb-6">
        <a href="{{ route('admin.users.index') }}" class="text-indigo-600 dark:text-indigo-400 hover:underline">
            ← Volver a usuarios
        </a>
    </div>
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Detalles del Usuario</h1>
            <a href="{{ route('admin.users.edit', $user->id) }}"
                class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                Editar Usuario
            </a>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Nombre
                </label>
                <p class="text-gray-900 dark:text-white">{{ $user->first_name }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Apellidos
                </label>
                <p class="text-gray-900 dark:text-white">{{ $user->last_name }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Email
                </label>
                <p class="text-gray-900 dark:text-white">{{ $user->email }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    ID de Contacto GoHighLevel
                </label>
                <p class="text-gray-900 dark:text-white font-mono">{{ $user->ghl_contact_id }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Sexo
                </label>
                <p class="text-gray-900 dark:text-white">
                    @if($user->gender)
                        {{ $user->gender === 'male' ? 'Masculino' : ($user->gender === 'female' ? 'Femenino' : 'Otro') }}
                    @else
                        No especificado
                    @endif
                </p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Fecha de Nacimiento
                </label>
                <p class="text-gray-900 dark:text-white">
                    {{ $user->date_of_birth ? $user->date_of_birth->format('d/m/Y') : 'No especificada' }}
                </p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Estado
                </label>
                <span class="px-2 py-1 text-xs rounded-full {{ $user->status ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200' }}">
                    {{ $user->status ? 'Activo' : 'Inactivo' }}
                </span>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Fecha de Creación
                </label>
                <p class="text-gray-900 dark:text-white">{{ $user->created_at->format('d/m/Y H:i') }}</p>
            </div>
        </div>
    </div>
</div>
@endsection

