<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = User::firstOrCreate(
            ['email' => 'admin@jpservicecooling.com'],
            [
                'name' => 'Administrator',
                'first_name' => 'Admin',
                'last_name' => 'User',
                'password' => Hash::make('Admin@123'),
                'is_admin' => true,
                'status' => true,
            ]
        );

        if ($admin->wasRecentlyCreated) {
            Log::info('Admin user created', [
                'email' => $admin->email,
                'user_id' => $admin->id,
            ]);
            $this->command->info('Admin user created successfully!');
            $this->command->warn('Default credentials: admin@example.com / password');
            $this->command->warn('Please change the password after first login!');
        } else {
            $this->command->info('Admin user already exists.');
        }
    }
}
