<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SystemSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class SettingController extends Controller
{
    /**
     * Display the settings page
     */
    public function index()
    {
        $ghlFormUrl = SystemSetting::getValue('ghl_form_url');
        
        return view('admin.settings.index', compact('ghlFormUrl'));
    }

    /**
     * Update the GHL form URL setting
     */
    public function updateGhlFormUrl(Request $request)
    {
        $validated = $request->validate([
            'ghl_form_url' => ['required', 'url', 'max:500'],
        ]);

        $oldUrl = SystemSetting::getValue('ghl_form_url');
        
        SystemSetting::setValue(
            'ghl_form_url',
            $validated['ghl_form_url'],
            'URL del formulario de GoHighLevel al que se redirigen los usuarios después del login'
        );

        Log::info('GHL form URL updated by admin', [
            'old_url' => $oldUrl,
            'new_url' => $validated['ghl_form_url'],
            'admin_id' => auth()->id(),
            'admin_email' => auth()->user()->email,
        ]);

        return redirect()->route('admin.settings.index')
            ->with('success', 'URL del formulario actualizada exitosamente.');
    }
}
